package jamezo97.clonecraft.network;

import jamezo97.clonecraft.entity.clone.EntityClone;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.INetworkManager;
import net.minecraft.util.ChatMessageComponent;
import net.minecraft.util.EnumChatFormatting;
import cpw.mods.fml.relauncher.Side;

public class Handler9TransferXP extends Handler{
	
	@Value(id = 0)
	int entityId;


	public Handler9TransferXP(int entityId) {
		this.entityId = entityId;
	}

	public Handler9TransferXP() {
		
	}
	
	@Override
	public void handle(Side side, INetworkManager manager, EntityPlayer player) {
		if(side == Side.SERVER){
			EntityClone clone = getCloneOnServer(entityId, player.worldObj);
			if(clone != null){
				if(clone.canUseThisEntity(player.username)){
					player.addExperience(clone.experienceTotal);
					clone.experience = 0;
					clone.experienceLevel = 0;
					clone.experienceTotal = 0;
					clone.onValueChanged(EntityClone.ID_EXPERIENCE, true);
				}else{
					player.sendChatToPlayer(ChatMessageComponent.createFromText("You can't do that.").setColor(EnumChatFormatting.RED));
				}
			}
		}
	}


}
